/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.AirCompressorBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.LiquidCompressorMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class LiquidCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<LiquidCompressorBlockEntity>,
ISerializableTanks,
MenuProvider {
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    @DescSynced
    @GuiSynced
    private final SmartSyncTank tank = new SmartSyncTank(this, 16000){

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return FuelRegistry.getInstance().getFuelValue(LiquidCompressorBlockEntity.this.f_58857_, stack.getFluid()) > 0;
        }
    };
    private final ItemStackHandler itemHandler = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || FluidUtil.getFluidHandler((ItemStack)itemStack) != null;
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    private double internalFuelBuffer;
    private float burnMultiplier = 1.0f;
    @GuiSynced
    public final RedstoneController<LiquidCompressorBlockEntity> rsController = new RedstoneController<LiquidCompressorBlockEntity>(this);
    @GuiSynced
    public float airPerTick;
    private float airBuffer;

    public LiquidCompressorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.LIQUID_COMPRESSOR.get(), pos, state, PressureTier.TIER_ONE, 5000);
    }

    LiquidCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volume) {
        super(type, pos, state, tier, volume, 4);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public boolean isActive() {
        return this.m_58900_().m_61138_((Property)AirCompressorBlock.ON) && (Boolean)this.m_58900_().m_61143_((Property)AirCompressorBlock.ON) != false;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.isActive() && this.nonNullLevel().f_46441_.nextInt(5) == 0) {
            ClientUtils.emitParticles(this.m_58904_(), this.m_58899_(), (ParticleOptions)ParticleTypes.f_123762_);
        }
    }

    @Override
    public void tickServer() {
        BlockState state;
        super.tickServer();
        this.processFluidItem(0, 1);
        boolean newIsActive = false;
        this.airPerTick = (float)this.getBaseProduction() * this.burnMultiplier * this.getSpeedMultiplierFromUpgrades() * ((float)this.getHeatEfficiency() / 100.0f);
        if (this.rsController.shouldRun()) {
            double fuelValue;
            double usageRate = (float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() * this.burnMultiplier;
            if (this.internalFuelBuffer < usageRate && (fuelValue = (double)FuelRegistry.getInstance().getFuelValue(this.f_58857_, this.tank.getFluid().getFluid()) / 1000.0) > 0.0) {
                int usedFuel = Math.min(this.tank.getFluidAmount(), (int)(usageRate / fuelValue) + 1);
                this.tank.drain(usedFuel, IFluidHandler.FluidAction.EXECUTE);
                this.internalFuelBuffer += (double)usedFuel * fuelValue;
                this.burnMultiplier = FuelRegistry.getInstance().getBurnRateMultiplier(this.f_58857_, this.tank.getFluid().getFluid());
            }
            if (this.internalFuelBuffer >= usageRate) {
                newIsActive = true;
                this.internalFuelBuffer -= usageRate;
                this.airBuffer += this.airPerTick;
                if (this.airBuffer >= 1.0f) {
                    int toAdd = (int)this.airBuffer;
                    this.addAir(toAdd);
                    this.airBuffer -= (float)toAdd;
                    this.addHeatForAir(toAdd);
                }
            }
        }
        if (newIsActive != this.isActive() && (state = this.m_58900_()).m_61138_((Property)AirCompressorBlock.ON)) {
            this.nonNullLevel().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)AirCompressorBlock.ON, (Comparable)Boolean.valueOf(newIsActive)));
        }
    }

    protected void addHeatForAir(int air) {
    }

    public int getHeatEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = this.getRotation();
        return orientation == dir || orientation == dir.m_122424_() || dir == Direction.UP;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128347_("internalFuelBuffer", this.internalFuelBuffer);
        tag.m_128350_("burnMultiplier", this.burnMultiplier);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.internalFuelBuffer = tag.m_128459_("internalFuelBuffer");
        this.burnMultiplier = tag.m_128457_("burnMultiplier");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public RedstoneController<LiquidCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new LiquidCompressorMenu(i, playerInventory, this.m_58899_());
    }
}

